#pragma once


extern HWND FindTvRockMainWindow();
extern HWND FindRockBar();

#define TVROCK_RESIZER_KEY "Software\\TvRock\\Resizer"

/* ߂
 [Uf[^: HKEY_CURRENT_USER\Software\TvRock
*/
class CRockBarResizer :
		public CWindowImplBase,
		public CDialogResize<CRockBarResizer>
{
public:
	#define	IDC_CHLIST		0x3EA
	#define	IDC_DEVICELIST	0x46A
	#define	IDC_RESERVELIST 0x3EB
	#define	IDC_PROGRAMINFO	0x4CB
	#define	IDC_VIEWSWITCH 0x408

	BEGIN_DLGRESIZE_MAP(CWindowResizer)
		DLGRESIZE_CONTROL(IDC_CHLIST,		DLSZ_SIZE_X | DLSZ_SIZE_Y)	// `lꗗ
		DLGRESIZE_CONTROL(IDC_DEVICELIST,	DLSZ_MOVE_X | DLSZ_SIZE_Y)	// foCXꗗ
		DLGRESIZE_CONTROL(IDC_RESERVELIST,	DLSZ_SIZE_X | DLSZ_SIZE_Y)	// ?
		DLGRESIZE_CONTROL(IDC_PROGRAMINFO,	DLSZ_SIZE_X | DLSZ_SIZE_Y)	// ԑg
		DLGRESIZE_CONTROL(0x403,               DLSZ_MOVE_Y)	// d
		DLGRESIZE_CONTROL(0x404,               DLSZ_MOVE_Y)	// ^
		DLGRESIZE_CONTROL(0x405,               DLSZ_MOVE_Y)	// ^~
		DLGRESIZE_CONTROL(0x40B,               DLSZ_MOVE_Y)	// XN[Vbg
		DLGRESIZE_CONTROL(0x46E, DLSZ_SIZE_X | DLSZ_MOVE_Y)	// Xe[^X
		DLGRESIZE_CONTROL(0x406, DLSZ_MOVE_X )	// ~
		DLGRESIZE_CONTROL(0x407, DLSZ_MOVE_X )	// ~̉
		DLGRESIZE_CONTROL(0x408, DLSZ_MOVE_X )	// ~̉̉
	END_DLGRESIZE_MAP()

	BEGIN_MSG_MAP_EX(CRockBarResizer)
		MSG_WM_ERASEBKGND(OnEraseBkGnd)
		MSG_WM_NCHITTEST(OnNcHitTest)
		MSG_WM_DESTROY(OnDestroy)
		MSG_WM_SIZE(OnSize)
		MSG_WM_QUERYENDSESSION(OnQueryEndSession)
		MSG_WM_NOTIFY(OnNotify)
		COMMAND_ID_HANDLER_EX(IDC_CHLIST, ChList_OnCommand)
		COMMAND_ID_HANDLER_EX(IDC_VIEWSWITCH, ViewSwitch_OnCommand)
		CHAIN_MSG_MAP(CDialogResize<CRockBarResizer>)
	END_MSG_MAP()

public:
	// DlgResize_Init łւȃX^Cݒ肳̂𖳗邽߂override
	DWORD GetStyle() {
		return WS_CHILD;
	}

	// 
	void Init(HWND hRockBar) {
		// TCYۑ
		CRect	rect;
		::GetWindowRect(hRockBar, &rect);
		m_OrgSize = rect.Size();

		// TuNX
		SubclassWindow(hRockBar);

		// WS_CLIPCHILDRENǉ(TCYƂ̃`΍)
		ModifyStyle(0, WS_CLIPCHILDREN);

		// [WۑāA
		SetWindowRgn(NULL);

		// Rg[̃CAEg
		DlgResize_Init(false, false, 0);

		// ݒ蕜
		{
			CRegKey	reg;
			if (reg.Open(HKEY_CURRENT_USER, _T(TVROCK_RESIZER_KEY), KEY_READ) == ERROR_SUCCESS) {
				DWORD	width = m_OrgSize.cx;
				DWORD	height = m_OrgSize.cy;
				reg.QueryDWORDValue(_T("Width"), width);
				reg.QueryDWORDValue(_T("Height"), height);
				
				SetWindowPos(0, 0, 0, width, height, SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);
			}
		}
		// TvRock̃f[^̃pX擾
		// Rocko[̔wi摜[h
		{
			CString	dataDir;

			CRegKey	reg;
			if (reg.Open(HKEY_CURRENT_USER, _T("Software\\TvRock"), KEY_READ) == ERROR_SUCCESS) {
				DWORD size = MAX_PATH;
				reg.QueryStringValue(_T("DOCUMENT"), dataDir.GetBuffer(size+1), &size);
				dataDir.ReleaseBuffer(size);
			}

			TCHAR	bmpPath[MAX_PATH+1] = {0};
			PathCombine(bmpPath, dataDir, _T("rockbar1.bmp"));

			m_Bmp.Attach(static_cast<HBITMAP>(
					::LoadImage(NULL, bmpPath, IMAGE_BITMAP, 0, 0, 
						LR_DEFAULTCOLOR | LR_LOADFROMFILE)
			));

		}
		
		#ifdef DEBUG
		// eXgp̃_~[eLXgݒ
		{
			HWND hList = GetDlgItem(IDC_CHLIST);
			::SetWindowLong(hList, GWL_STYLE,
				::GetWindowLong(hList, GWL_STYLE) & ~LVS_NOCOLUMNHEADER);

			CListViewCtrl	lv(hList);
			lv.InsertItem(0, _T("݁[Ă"));
			lv.SetItemText(0, 1, _T("݁[Ă"));
			lv.SetItemText(0, 2, _T("݁[Ă"));
		}
		#endif

		// ĕ`
		Invalidate();
	}


protected:

	CSize		m_OrgSize;
	CBitmap		m_Bmp;
	BOOL		m_bScanMenu;
	BOOL		m_bResetColumnWidth;

	// WM_DESTROY
	void OnDestroy() {
		SetMsgHandled(FALSE);
		Uninit();
	}

	// WM_ERASEBKGND
	LRESULT OnEraseBkGnd(HDC hDC) {
		// wi`
		SetMsgHandled(TRUE);

		CDCHandle	dc(hDC);

		CRect	cr;
		GetClientRect(&cr);

		if (!m_Bmp.IsNull()) {
			// rbg}bv[hłĂ`
			CDC	tmp_dc;
			tmp_dc.CreateCompatibleDC();
			tmp_dc.SelectBitmap(m_Bmp);

			CSize	bmpSize;
			m_Bmp.GetSize(bmpSize);

			if (0) {
				// PȈ΂
				dc.StretchBlt(0, 0, cr.right, cr.bottom, 
						tmp_dc, 1, 1, bmpSize.cx-1, bmpSize.cy-1, SRCCOPY);
			}
			else {
				// Â΂

				// Rocko[̃ftHg̉摜ɂԊO̍O
				CPoint	offset(1,1);
				bmpSize.cx -= offset.x * 2;
				bmpSize.cy -= offset.y * 2;

				bmpSize.cx--;
				bmpSize.cy--;

				// ΂̈ƈ΂Ȃ̈𕪗ĕ`
				int	px[] = {20, 0, 9};	// Œ̈̃TCY ,dummy,E
				int	py[] = {9,  0, 9};	// Œ̈̃TCY ,dummy,

				int srcY = offset.y;
				int dstY = 0;
				for (int r=0; r<3; r++) {
					int srcHeight = (r == 1 ? (bmpSize.cy  - py[0] - py[2]) : py[r] );
					int dstHeight = (r == 1 ? (cr.Height() - py[0] - py[2]) : srcHeight);

					int srcX = offset.x;
					int dstX = 0;
					for (int c=0; c<3; c++) {
						int srcWidth = (c == 1 ? (bmpSize.cx - px[0] - px[2]) : px[c]);
						int dstWidth = (c == 1 ? (cr.Width() - px[0] - px[2]) : srcWidth);
						
						dc.StretchBlt(dstX, dstY, dstWidth, dstHeight,
							tmp_dc, srcX, srcY, srcWidth, srcHeight, SRCCOPY);

						srcX += srcWidth;
						dstX += dstWidth;
					}

					srcY += srcHeight;
					dstY += dstHeight;
				}
			}
		}
		else {
			// rbg}bv[hłĂȂƂ́Â؂
			dc.DrawEdge(cr, BDR_RAISED, BF_RECT | BF_MIDDLE);
		}

		return 1;
	}

	
	// WM_NCHITTEST
	LRESULT OnNcHitTest(CPoint pt) {
		// E[Ɖ[hbOăEBhETCYύXł悤ɂ
		const int	grip = 6;
		CRect		rc;

		GetWindowRect(&rc);

		DWORD idx = 
			 (pt.y <= rc.top    + grip ? 1 : 0)		// [
			+(pt.y >= rc.bottom - grip ? 2 : 0)		// [
			+(pt.x <= rc.left   + grip ? 4 : 0)		// [
			+(pt.x >= rc.right  - grip ? 8 : 0);	// E[
		if (idx > 0) {
			if (idx & 1) {
				if (idx & 4) return HTTOPLEFT;
				if (idx & 8) return HTTOPRIGHT;
				return HTTOP;
			}
			else if(idx & 2) {
				if (idx & 4) return HTBOTTOMLEFT;
				if (idx & 8) return HTBOTTOMRIGHT;
				return HTBOTTOM;
			}
			else {
				if (idx & 4) return HTLEFT;
				if (idx & 8) return HTRIGHT;
			}
		}

		SetMsgHandled(FALSE);
		return 0;
	}

	// 
	void Uninit()  {
		// ݒۑ
		SaveWindowSize();

		// TCY߂
		SetWindowPos(0, 0, 0, m_OrgSize.cx, m_OrgSize.cy, 
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);

		// CAEg߂
		{
			CRect	crc;
			GetClientRect(crc);
			DlgResize_UpdateLayout(crc.Width(), crc.Height());
		}

		// TuNXčĕ`
		HWND hRockBar = UnsubclassWindow();
		::InvalidateRect(hRockBar, NULL, TRUE);

		// 炷
		/*
		for (int j=0; j<3; j++) {
			MessageBeep(MB_OK);
			Sleep(50);
		}*/
	}

	// WM_SIEZE
	void OnSize(UINT nType, CSize size) {

		// gTCY(CHAIN_MSG_MAPŏɂĂƂ낾A
		// ̌̏ǉ̂Ńnh)

		DlgResize_UpdateLayout(size.cx, size.cy);

		// Xgr[̃J̕Xg̑傫ɍ킹
		ResetColumnWidth();

		// [Wݒ(pۂ)
		if (1) {
			CRgnHandle 	rgn;
			rgn.CreateRoundRectRgn(0, 0, size.cx+1, size.cy+1, 6, 6);
			SetWindowRgn(rgn, TRUE);
		}

	}

	LRESULT OnNotify(int idCtrl, LPNMHDR pn) {
		SetMsgHandled(FALSE);
		if (pn->idFrom == IDC_CHLIST) {
			switch (pn->code) {
			case LVN_INSERTITEM:
				ATLTRACE(_T("LVN_INSERTITEM\n"));
				if (!m_bResetColumnWidth) {
					m_bResetColumnWidth = TRUE;
					PostMessage(WM_COMMAND, IDC_CHLIST, 0);
				}
				break;
			}
		}
		return 0;
	}

	void ChList_OnCommand(UINT uNotifyCode, int nID, CWindow wndCtl) {
		if (m_bResetColumnWidth) {
			m_bResetColumnWidth = FALSE;
			ResetColumnWidth();
		}
		else {
			SetMsgHandled(FALSE);
		}
	}

	void ViewSwitch_OnCommand(UINT uNotifyCode, int nID, CWindow wndCtl) {
		SetMsgHandled(FALSE);
		CRect rc;
		GetClientRect(&rc);
		PostMessage(WM_SIZE, 0, MAKELPARAM(rc.Width(), rc.Height()));
		//ResetColumnWidth();
	}

	void ResetColumnWidth() {
		ATLTRACE(_T("ResetColumnWidth\n"));
		CListViewCtrl	lv(GetDlgItem(IDC_CHLIST));

		CRect	cr;
		lv.GetClientRect(cr);

		CRect	ir;
		lv.SetColumnWidth(0, -1);
		lv.SetColumnWidth(1, -1);
		//lv.SetColumnWidth(2, -1);
		lv.GetSubItemRect(0, 2, LVIR_BOUNDS, ir);
		lv.SetColumnWidth(2, cr.right - ir.left);
	}

	void SaveWindowSize() {
		CRect	rect;
		GetWindowRect(&rect);

		CRegKey	reg;
		if (reg.Create(HKEY_CURRENT_USER, _T(TVROCK_RESIZER_KEY)) == ERROR_SUCCESS) {
			// EBhETCYۑ
			reg.SetDWORDValue(_T("Width"), rect.Width());
			reg.SetDWORDValue(_T("Height"), rect.Height());
		}
	}

	LRESULT OnQueryEndSession(UINT wParam, UINT lParam) {
		SetMsgHandled(FALSE);
		SaveWindowSize();

		return 0;
	}

};
