// MainDlg.h : interface of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include <atltime.h>

class CMainDlg : public CDialogImpl<CMainDlg>, public CUpdateUI<CMainDlg>,
		public CMessageFilter, public CIdleHandler
{
public:
	enum { IDD = IDD_MAINDLG };
	enum {
		Timer_Update = 1,
		Timer_UpdateInterval = 1000,
		Timer_Fire = 2,
	};
	CTime	m_StopTime;

	virtual BOOL PreTranslateMessage(MSG* pMsg)
	{
		return CWindow::IsDialogMessage(pMsg);
	}

	virtual BOOL OnIdle()
	{
		return FALSE;
	}

	BEGIN_UPDATE_UI_MAP(CMainDlg)
	END_UPDATE_UI_MAP()

	BEGIN_MSG_MAP(CMainDlg)
		MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
		MESSAGE_HANDLER(WM_TIMER, OnTimer)
		COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
		COMMAND_CODE_HANDLER(BN_CLICKED, OnButtonClicked)
	END_MSG_MAP()

// Handler prototypes (uncomment arguments if needed):
//	LRESULT MessageHandler(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
//	LRESULT CommandHandler(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
//	LRESULT NotifyHandler(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)

	LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
	{
		// center the dialog on the screen
		CenterWindow();

		// set icons
		HICON hIcon = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
			IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
		SetIcon(hIcon, TRUE);
		HICON hIconSmall = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
			IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
		SetIcon(hIconSmall, FALSE);

		// register object for message filtering and idle updates
		CMessageLoop* pLoop = _Module.GetMessageLoop();
		ATLASSERT(pLoop != NULL);
		pLoop->AddMessageFilter(this);
		pLoop->AddIdleHandler(this);

		UIAddChildWindowContainer(m_hWnd);

		// c莞Ԃ̃ftHg
		m_StopTime = CTime::GetCurrentTime();
		AddTime(CTimeSpan(0, 0, 30, 0));

		// c莞ԕ\̍XVԊu
		SetTimer(Timer_Update, Timer_UpdateInterval);

		UpdateCountDownText();

		return TRUE;
	}

	LRESULT OnCancel(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
	{
		int r = MessageBox(_T("I܂H"), _T("LZ"), 
					MB_OKCANCEL | MB_ICONQUESTION);
		if(r==IDOK) {
			CloseDialog(wID);
		}

		return 0;
	}

	LRESULT OnButtonClicked(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& bHandled)
	{
		bHandled = FALSE;
		switch(wID) {
		case IDC_INC1:
			AddTime(CTimeSpan(0, 0, 1, 0));
			break;
		case IDC_INC2:
			AddTime(CTimeSpan(0, 0, 15, 0));
			break;
		case IDC_DEC1:
			AddTime(CTimeSpan(0, 0, -1, 0));
			break;
		case IDC_DEC2:
			AddTime(CTimeSpan(0, 0, -15, 0));
			break;
		default:
			bHandled = TRUE;
			break;
		}
		return 0;
	}

	void CloseDialog(int nVal)
	{
		DestroyWindow();
		::PostQuitMessage(nVal);
	}

	LRESULT OnTimer(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
	{
		switch(wParam) {
		case Timer_Update:
			UpdateCountDownText();
			break;
		case Timer_Fire:
			KillTimer(Timer_Update);
			KillTimer(Timer_Fire);
			pv3stop();
			CloseDialog(IDOK);
			break;
		}
		return 0;
	}

	void UpdateCountDownText()
	{
		CTimeSpan	t = m_StopTime - CTime::GetCurrentTime();

		/*
		const int textLen = 100;
		TCHAR	text[textLen];
		StrFromTimeInterval(text, textLen,
			t.GetTotalSeconds() * 1000, 100);
			*/
		CString	text;
		if(t.GetTotalMinutes() > 0) {
			text.Format(_T("%d %db"), 
				static_cast<int>(t.GetTotalMinutes()),
				static_cast<int>(t.GetTotalSeconds()) % 60);
		}
		else {
			text.Format(_T("%db"), 
				static_cast<int>(t.GetTotalSeconds()));
		}
		text.Append(_T("PV3̘^~܂"));
		SetDlgItemText(IDC_COUNTDOWNTEXT, text);
	}

	void AddTime(CTimeSpan ts) 
	{
		m_StopTime += ts;

		CTimeSpan	t = m_StopTime - CTime::GetCurrentTime();
		if(t.GetTotalSeconds() > 0) {
			SetTimer(Timer_Fire, static_cast<UINT>(t.GetTotalSeconds() * 1000));
			SetTimer(Timer_Update, Timer_UpdateInterval);
		}
		else {
			KillTimer(Timer_Fire);
		}
		UpdateCountDownText();
	}

	void pv3stop()
	{
		int cmd = 1024;
		HWND hWnd = FindWindow(_T("http://earthsoft.jp/PV3/Window/Player"), NULL);
		if(hWnd==NULL) {
			cmd = 4864;
			hWnd = FindWindow(_T("http://earthsoft.jp/PV3/PV3.exe/Window"), NULL);
		}
		if(hWnd) {
			CWindow	w(hWnd);
			CString	title;

			w.GetWindowText(title);
			if(title.Find(_T("^"))!=-1) {
				::PostMessage(hWnd, WM_COMMAND, MAKEWPARAM(cmd,0), 0);
				MessageBox(_T("PV3̘^Ԃ~܂"), _T(""), 
					MB_OK | MB_ICONINFORMATION);
			}
			else {
				MessageBox(_T("PV3͘^撆ł͂܂ł"), NULL, 
					MB_OK | MB_ICONEXCLAMATION);
			}
		}
		else {
			MessageBox(_T("PV3̃EBhE܂ł"), NULL, 
				MB_OK | MB_ICONSTOP);
		}
	}
};
